---
generated_at: 2026-02-10 11:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-コード補完 (IntelliSense)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードから確認可能

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/Completion/CompletionService.cs`
- E-02: `src/Features/Core/Portable/Completion/CompletionItem.cs`
- E-03: `src/Features/Core/Portable/Completion/CompletionTrigger.cs`
- E-04: `src/Features/Core/Portable/Completion/CompletionOptions.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CompletionServiceはabstract classでILanguageService実装 | E-01 (31行目) | ○ |
| C-02 | GetServiceでドキュメントから言語固有サービス取得 | E-01 (51-52行目) | ○ |
| C-03 | Language抽象プロパティ | E-01 (65行目) | ○ |
| C-04 | ShouldTriggerCompletionでトリガー判定 | E-01 (94-110行目) | ○ |
| C-05 | TriggerOnTypingオプション対応 | E-01 (145-146行目) | ○ |
| C-06 | TriggerOnDeletionオプション対応 | E-01 (112-113行目 SupportsTriggerOnDeletion) | ○ |
| C-07 | GetDefaultCompletionListSpanメソッド | E-01 (174-178行目) | ○ |
| C-08 | GetDescriptionAsyncで候補説明取得 | E-01 (186-193行目) | ○ |
| C-09 | CompletionTriggerKind列挙型 | E-03 (トリガー種別定義) | ○ |
| C-10 | Invoke/InvokeAndCommitIfUnique/Insertion/Deletion | E-01 (142-143行目で参照) | ○ |
| C-11 | ProviderManagerでプロバイダー管理 | E-01 (34行目 _providerManager) | ○ |
| C-12 | MEFでCompletionProvider読み込み | Globでプロバイダーファイル確認 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能なサービス構造
- 0: 低リスク - トリガー判定ロジックの記述
- 0: 低リスク - プロバイダー一覧の記述

## 6) レビュアーチェックリスト（最小）
- [ ] CompletionServiceの主要メソッドが網羅されているか確認
- [ ] CompletionTriggerKindの値が正確か確認
- [ ] CompletionOptionsの説明が正確か確認
- [ ] 主要なCompletionProviderが網羅されているか確認
